// AppDlg.cpp : implementation file
//

#include "stdafx.h"
#include "App.h"
#include "AppDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAppDlg dialog




CAppDlg::CAppDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAppDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAppDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST2, list1);
}

BEGIN_MESSAGE_MAP(CAppDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


// CAppDlg message handlers

BOOL CAppDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	RECT r;
	list1.GetWindowRect(&r);

	int szerListy = r.right - r.left;
	int szerKolumny = szerListy / 7;

	// TODO: Add extra initialization here
	list1.InsertColumn(0,L"Tytu Okna",LVCFMT_LEFT, szerKolumny, 0);
	list1.InsertColumn(1,L"Nazwa Klasy Okna",LVCFMT_LEFT, szerKolumny, 0);
	list1.InsertColumn(2,L"ID okna",LVCFMT_LEFT, szerKolumny, 0);
	list1.InsertColumn(3,L"Uchwyt",LVCFMT_LEFT, szerKolumny, 0);
	list1.InsertColumn(4,L"Stan Okna",LVCFMT_LEFT, szerKolumny, 0);
	list1.InsertColumn(5,L"Pooenie",LVCFMT_LEFT, szerKolumny, 0);
	list1.InsertColumn(6,L"Rozmiar",LVCFMT_LEFT, szerKolumny, 0);
	
	::EnumWindows((WNDENUMPROC)DodajWiersz,(LPARAM)&list1);


	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAppDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAppDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

int CALLBACK CAppDlg::DodajWiersz(HWND uchwyt, LPARAM lParam)
{

	CListCtrl * list = (CListCtrl*)lParam;

	const int MAX_CHAR_SIZE=128;

	wchar_t tytul[MAX_CHAR_SIZE];
	wchar_t nazwaKlasy[MAX_CHAR_SIZE];
	DWORD idProcesu;
	WINDOWPLACEMENT ustawieniaOkna;
	::GetWindowText(uchwyt,tytul,MAX_CHAR_SIZE);
	::GetClassName(uchwyt,nazwaKlasy,MAX_CHAR_SIZE);
	::GetWindowThreadProcessId(uchwyt,&idProcesu);
	::GetWindowPlacement(uchwyt,&ustawieniaOkna);

	CString stanOkna;
	switch (ustawieniaOkna.showCmd)
	{
		case SW_HIDE: stanOkna.Append(L"ukryte"); break;
		case SW_MAXIMIZE: stanOkna.Append(L"zmaksymalizowane"); break;
		case SW_MINIMIZE:
		case SW_SHOWMINIMIZED:
		case SW_SHOWMINNOACTIVE : stanOkna.Append(L"zminimalizowane"); break;
		case SW_SHOWNORMAL:
		case SW_SHOW:
		case SW_SHOWNA:
		case SW_SHOWNOACTIVATE:
		case SW_RESTORE: stanOkna.Append(L"normalne"); break;
	}
	int szerOkna=ustawieniaOkna.rcNormalPosition.right-ustawieniaOkna.rcNormalPosition.left;
	int wysOkna=ustawieniaOkna.rcNormalPosition.bottom-ustawieniaOkna.rcNormalPosition.top;

	if (::IsWindowVisible(uchwyt))
	{
		int row = list->GetHeaderCtrl()->GetItemCount() - 1;
		int index = list->InsertItem(row, tytul);
		list->SetItem(index, 1, LVIF_TEXT, nazwaKlasy, 0, 0, 0, NULL);
		CString sIdProcesu;
		sIdProcesu.AppendFormat(L"%d",idProcesu);
		list->SetItem(index, 2, LVIF_TEXT, sIdProcesu, 0, 0, 0, NULL);
		CString sUchwyt;
		sUchwyt.AppendFormat(L"%d",(int)uchwyt);
		list->SetItem(index, 3, LVIF_TEXT, sUchwyt, 0, 0, 0, NULL);
		list->SetItem(index, 4, LVIF_TEXT, stanOkna, 0, 0, 0, NULL);
		CString pozycja;
		pozycja.AppendFormat(L"x=%d y=%d",ustawieniaOkna.rcNormalPosition.left,ustawieniaOkna.rcNormalPosition.top);
		if (stanOkna.Compare(L"zminimalizowane") == 0) 
			list->SetItem(index, 5, LVIF_TEXT, L" ", 0, 0, 0, NULL);
		else
			list->SetItem(index, 5, LVIF_TEXT, pozycja, 0, 0, 0, NULL);
		CString rozmiar;
		rozmiar.AppendFormat(L"%d x %d",szerOkna,wysOkna);
		list->SetItem(index, 6, LVIF_TEXT, rozmiar, 0, 0, 0, NULL);
	}

	return 1;
}
